## Layer 2 Data Plane Security Features

- The data plane of a switch can protect network devices and endpoints against Layer 2 attacks.

---

### Main Categories of Security Features

#### 1. Traffic Filtering Features

- Prevents identity theft and spoofing attacks (e.g., MAC, DHCP, ARP spoofing).
- Limits flooding attacks.
- Restricts access to network devices.
- Protects network-connected endpoints from various attacks.

#### 2. Traffic Conditioning / Quality of Service (QoS)

- Controls and enforces proper use of network links.

#### 3. Transmission Protection Features

- Cryptographically encapsulates network traffic over untrusted networks using IEEE 802.1AE MACsec.

---

## Key Layer 2 Data Plane Controls

### DHCP Snooping

- Prevents DHCP server spoofing attacks.
- Mitigates DHCP starvation.
- Filters untrusted DHCP messages.
- Maintains a DHCP snooping binding database (binding table).

### ARP Inspection

- Prevents ARP spoofing attacks.
- Intercepts and validates all ARP requests and responses.
- Verifies MAC-to-IP address bindings before forwarding.
- Drops ARP replies with invalid bindings.

### Traffic Storm Control

- Monitors incoming traffic levels per port over 1-second intervals.
- Compares traffic against a configured control level (percentage of available bandwidth).
- Applies to all traffic types: broadcast, multicast, and unicast.

### Private VLAN (PVLAN)

- Provides Layer 2 isolation between ports within the same VLAN.
- Eliminates the need for separate VLANs and subnets for isolation.
- Offers a simple, coarse access control mechanism.

### MACsec Encryption

- Delivers MAC-layer encryption over wired networks.
- Uses out-of-band (OOB) methods for key management.
- Encrypts switch-to-switch links (e.g., access to distribution, dark-fiber links).

---
